﻿using System;
using System.Linq;

using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
    public class PatientImageDetailDB : DBUtils
    {
        public PatientImageDetail GetItem(string CURRENT_USER, int CURRENT_REGISTRY_ID, int PATIENT_IMAGE_ID)
        {
            PatientImageDetail objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_GetPatientImageDetail(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_IMAGE_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }
    }
}
